import partition from 'lodash/partition';
import {momentTimezone as moment} from '../../../reexports';

import {params} from '../yaMetrika';
import isAllDaysSearch from '../search/isAllDaysSearch';

/**
 * Метод отправляет событие если в поиске на дату отображаются только сниппеты на следующую дату
 * @param {Object[]} segments - массив сегментов
 * @param {Object} context - поисковый контекст
 */
export default function reachGoalTomorrowSegments(segments, context) {
    const {when, time, from} = context;
    const today = moment.tz(time.now, from.timezone);
    const date = moment.tz(when.date, from.timezone);

    if (segments.length && !isAllDaysSearch(context)) {
        const [dateSegments, nextDateSegments] = partition(
            segments.filter(({isGone}) => !isGone),
            ({departure, stationFrom}) =>
                date.isSame(moment.tz(departure, stationFrom.timezone), 'day'),
        );
        const paramKey = today.isSame(date, 'day')
            ? 'onlyTomorrowSegments'
            : 'onlyNextDateSegments';
        const noOneVisibleSegmentOnDate = dateSegments.length === 0;
        const anySegmentOnNextDate = nextDateSegments.length !== 0;

        params({
            [paramKey]: noOneVisibleSegmentOnDate && anySegmentOnNextDate,
        });
    }
}
