import {reachGoalOnce} from '../yaMetrika';
import {getTrainSegmentsRatio} from '../segments/getTransportTypeRatio';

/**
 * Метод для логирования соотношения поездов в результатах поиска
 * @param {Object[]} segments - массив сегментов
 */
export default function reachGoalTrainsRatio(segments) {
    const ratio = getTrainSegmentsRatio(segments);

    if (!isNaN(ratio)) {
        if (ratio >= 50) {
            reachGoalOnce('train-segments-ratio-50');
        }

        if (ratio >= 80) {
            reachGoalOnce('train-segments-ratio-80');
        }
    }
}
