import {params} from '../yaMetrika';
import {BUS_TYPE} from '../transportType';
import {YBUS} from '../segments/tariffSources';

export default function reachGoalYBus(segments, context) {
    const busSegments = [];
    const yandexBusSegments = [];
    const othersBusSegments = [];

    segments.forEach(segment => {
        if (segment.transport.code !== BUS_TYPE) {
            return;
        }

        busSegments.push(segment);
        (segment.source === YBUS ? yandexBusSegments : othersBusSegments).push(
            segment,
        );
    });

    params({
        rideName: `${context.from.title} — ${context.to.title}`,
        segmentsCount: segments.length,
        busSegmentsCount: busSegments.length,
        yandexBusSegmentsCount: yandexBusSegments.length,
        othersBusSegmentsCount: othersBusSegments.length,
        yandexBusOfflineSegmentsCount: yandexBusSegments.filter(
            ({canPayOffline}) => canPayOffline,
        ).length,
        othersBusSegments: othersBusSegments.map(segment => {
            const getDataProviderId = ({thread: {uid = ''} = {}}) =>
                uid.split('_').pop();
            const nestedSegments = segment.isTransfer
                ? segment.segments
                : [segment];

            return {dataProviders: nestedSegments.map(getDataProviderId)};
        }),
    });
}
