import partition from 'lodash/partition';
import {reachGoalOnce} from '../yaMetrika';

export default function reachGoalsTransportTypes(segments, context) {
    const [dynamicSegments, staticSegments] = partition(segments, 'isDynamic');
    const dynamicTypes = [
        ...new Set(dynamicSegments.map(({transport}) => transport.code)),
    ];
    const staticTypes = [
        ...new Set(staticSegments.map(({transport}) => transport.code)),
    ];
    const allTypes = [...new Set([...dynamicTypes, ...staticTypes])];
    const newTypes = dynamicTypes.filter(type => !staticTypes.includes(type));

    reachGoalOnce(allTypes.sort().join('-'));

    if (newTypes.length) {
        const {from, to, when} = context;

        reachGoalOnce('transport-types-was-extended', {
            'transport-types': newTypes,
            query: [from.key, to.key, when.date].join('&'),
        });
    }
}
