export function bindMethods(object, methodNames) {
    methodNames.forEach(methodName => {
        object[methodName] = object[methodName].bind(object);
    });
}

export function getObjectWithoutProps(obj = {}, properties = []) {
    return properties.reduce(
        (result, property) => {
            delete result[property];

            return result;
        },
        {...obj},
    );
}
