import {TransportType} from '../transportType';

import {TrainPartner} from './trainPartners';
import {OrderUrlOwner} from '../segments/tariffClasses';

import isUssrThread from '../segments/isUssrThread';
import isUkrainianSegment from '../segments/isUkrainianSegment';
import areTrainTariffsAvailableForSegment from '../segments/tariffs/areTrainTariffsAvailableForSegment';

/**
 * Проверяет необходимость использования ссылок покупки на сервис поездов
 * RASPFRONT-2671
 * @param {Object} segment - сегмент выдачи
 * @return {boolean}
 */
export default function shouldUseLinkToTrains(segment) {
    const {
        transport: {code: transportType},
        thread,
        stationFrom,
        stationTo,
        oldUfsOrder,
        runDays,
        trainPartners = [],
        tariffs,
        trainPurchaseNumbers,
    } = segment;

    // Поиск на все дни. В этом случае ссылки на покупку формируются нами
    if (runDays) {
        if (
            transportType !== TransportType.train &&
            transportType !== TransportType.suburban
        ) {
            return false;
        }

        if (transportType === TransportType.suburban && !trainPurchaseNumbers) {
            return false;
        }

        return (
            trainPartners.includes(TrainPartner.im) &&
            !oldUfsOrder &&
            isUssrThread(thread) &&
            !isUkrainianSegment({stationFrom, stationTo})
        );
    }

    // Поиск на дату. В этом счлучае ссылки на покупку приезжают с бекэнда.
    if (!areTrainTariffsAvailableForSegment(segment)) {
        return false;
    }

    if (!tariffs || !tariffs.classes) {
        return false;
    }

    const tariffFromTrains = Object.values(tariffs.classes).find(tariff => {
        const {trainOrderUrl, orderUrl, trainOrderUrlOwner} = tariff;

        return (
            trainOrderUrlOwner === OrderUrlOwner.trains &&
            (trainOrderUrl || orderUrl)
        );
    });

    return Boolean(tariffFromTrains);
}
