export const IOS = 'iOS';

/**
 * Функция определения оси и её версии
 * @param { Object } os - данные ОС
 * @param { string } name - имя ОС для сравнения
 * @param { number } version - мажорный номер ОС для сравнения
 * @return { boolean }
 */
export function isOS(os, name, version) {
    return (
        os.name === name &&
        (version ? parseInt(os.version, 10) === version : true)
    );
}

export function isIOS(os, version = 0) {
    return isOS(os, IOS, version);
}
