import {SEARCH} from '../routes/search';

/**
 * Проверяет является ли страницой поиска текущая страница или страница в обработке
 * @param {Object} page - объект page из store
 * @param {boolean} [checkFetching=false] - проверять ли страницу в обработке (в статусе fetching),
 * @return {boolean}
 */
export function isSearch({page}, checkFetching = false) {
    const fetchingStatus = checkFetching && page.fetching === SEARCH;

    return page.current === SEARCH || fetchingStatus;
}
