import PointType from '../../interfaces/PointType';

export function getPointType({key} = {}) {
    if (key && (typeof key === 'string' || key instanceof String)) {
        return key.charAt(0).toLowerCase();
    }
}

export function isStation(point = {}) {
    if (point.key) {
        return getPointType(point) === PointType.station;
    }

    return false;
}

export function isCity(point = {}) {
    if (point.key) {
        return getPointType(point) === PointType.city;
    }

    return false;
}

export function getStationPointById(id) {
    return `${PointType.station}${id}`;
}

export function getCityPointById(id) {
    return `${PointType.city}${id}`;
}
