export const SHOW_POPULAR_DIRECTIONS_COUNT = 5;
export const SHOW_POPULAR_DIRECTIONS_FOR_BOTS_COUNT = 10;

/**
 * Метод настраивает количество популярных направлений в зависимости от user-agent
 * @param { Object } popularDirections - популярные направления
 * @param { boolean } isBot - идет ли запрос от бота
 * @return { Object } popularDirections - popularDirections с настроенным количеством популярных направлений
 */
export function configurePopularDirections(popularDirections, isBot) {
    const {
        to: {points: toPoints},
        from: {points: fromPoints},
    } = popularDirections;
    const pointsCount = isBot
        ? SHOW_POPULAR_DIRECTIONS_FOR_BOTS_COUNT
        : SHOW_POPULAR_DIRECTIONS_COUNT;

    popularDirections.to.points = toPoints.slice(0, pointsCount);
    popularDirections.from.points = fromPoints.slice(0, pointsCount);

    return popularDirections;
}
