import sample from 'lodash/sample';

const teaserTypes = ['ahtung', 'special', 'normal'];

/**
 * Возвращает случайный тизер с максимальным приоритетом
 * @param {Object[]} teasers - список тизеров
 * @return {Object} - тизер
 */
function selectRandomOfMaxImportance(teasers) {
    const maxImportance = teasers.reduce(
        (prevMax, teaser) =>
            teaser.importance > prevMax ? teaser.importance : prevMax,
        0,
    );

    const importantTeasers = teasers.filter(
        teaser => teaser.importance === maxImportance,
    );

    return sample(importantTeasers);
}

/**
 * Возвращает список тизеров, по одному каждого типа
 * @param {Object} teasers - объект с тизерами, ключи - типы
 * @return {Object[]} - список тизеров
 */
export default function prepareTeasersForIndexPage(teasers) {
    return teaserTypes.reduce((accum, type) => {
        const currentTeasers = teasers[type];

        if (currentTeasers && currentTeasers.length) {
            const teaser =
                currentTeasers.length > 1
                    ? selectRandomOfMaxImportance(currentTeasers)
                    : currentTeasers[0];

            if (teaser) {
                accum.push({
                    ...teaser,
                    type: type === 'ahtung' ? 'attention' : type,
                });
            }
        }

        return accum;
    }, []);
}
