export function calcSizeCache(containerSize, initialItemSizes) {
    const itemSizes = [];
    const itemOffsets = [];

    initialItemSizes.reduce((offset, size) => {
        itemSizes.push(size);
        itemOffsets.push(offset);

        return offset + size;
    }, 0);

    const l = initialItemSizes.length;
    const diff = containerSize - itemSizes[l - 1] - itemSizes[l - 2];

    if (diff > 0) {
        itemOffsets[l - 2] -= diff;
        itemSizes[l - 2] += diff;
        itemSizes[l - 3] -= diff;
    }

    return {
        containerSize,
        itemSizes,
        itemOffsets,
    };
}

export function calcAbsoluteScroll(relativeScroll, {itemOffsets, itemSizes}) {
    const i = Math.floor(relativeScroll);

    return itemOffsets[i] + itemSizes[i] * (relativeScroll - i);
}

export function calcRelativeScroll(absoluteScroll, {itemOffsets, itemSizes}) {
    let i = 0;

    while (itemOffsets[i] <= absoluteScroll) {
        i++;
    }

    i--;

    return i + (absoluteScroll - itemOffsets[i]) / itemSizes[i];
}
