import {LANG_RU, LANG_UK} from './lang/langCodes';

import keyset from '../i18n/route-title';

const requiredTitleForms = {
    [LANG_RU]: {
        from: 'titleGenitive',
        to: 'titleAccusative',
    },
    [LANG_UK]: {
        from: 'titleGenitive',
        to: 'titleGenitive',
    },
};

function getDefaultToPreposition(language) {
    if (language === LANG_RU) {
        return 'в';
    }

    return '';
}

export function getRouteTitleInflected({from, to, language}) {
    if (
        !requiredTitleForms[language] ||
        !from[requiredTitleForms[language].from] ||
        !to[requiredTitleForms[language].to]
    ) {
        return keyset('title-infinitive', {from, to});
    }

    const params = {
        from,
        to: {
            ...to,
            preposition: to.preposition || getDefaultToPreposition(language),
        },
    };

    return keyset('title-inflected', params);
}

export default function getRouteTitle({from, to, language}) {
    return {
        titleInfinitive: keyset('title-infinitive', {from, to}),
        titleInflected: getRouteTitleInflected({from, to, language}),
    };
}
