import {TransportType} from '../transportType';

import PlaneCalendarDayLink from '../../components/PlaneCalendarDayLink/PlaneCalendarDayLink';
import ThreadCalendarDayLink from '../../components/ThreadCalendarDayLink/ThreadCalendarDayLink';
import OrderCalendarDayLink from '../../components/OrderCalendarDayLink/OrderCalendarDayLink';

type TDayComponentType =
    | typeof PlaneCalendarDayLink
    | typeof OrderCalendarDayLink
    | typeof ThreadCalendarDayLink;

interface IGetDayComponentParams {
    transportType: TransportType;
    trainPurchaseNumbers?: string[];
}

export function getAllDaysLinkComponent({
    transportType,
    trainPurchaseNumbers,
}: IGetDayComponentParams): TDayComponentType {
    switch (transportType) {
        case TransportType.plane:
            return PlaneCalendarDayLink;
        case TransportType.suburban:
            return trainPurchaseNumbers
                ? OrderCalendarDayLink
                : ThreadCalendarDayLink;
        case TransportType.train:
            return OrderCalendarDayLink;

        default:
            return ThreadCalendarDayLink;
    }
}
