import ISegmentTariffs from '../../interfaces/segment/ISegmentTariffs';
import IPrice from '../../interfaces/state/IPrice';

export function getMinPriceFromTariffs(
    tariffs: ISegmentTariffs<{price: IPrice}>[],
): IPrice | null {
    if (!tariffs.length) {
        return null;
    }

    return tariffs.reduce<IPrice | null>((min, {classes}) => {
        const minTariffPrice = Object.values(classes).reduce<IPrice | null>(
            (res, {price}) => {
                if (!res) {
                    return price;
                }

                return res.value > price.value ? price : res;
            },
            null,
        );

        if (!minTariffPrice) {
            return min;
        }

        if (!min) {
            return minTariffPrice;
        }

        return minTariffPrice.value < min.value ? minTariffPrice : min;
    }, null);
}
