import {FilterTransportType} from '../transportType';
import IPoint from '../../interfaces/state/searchForm/IPoint';

import keyset from '../../i18n/search';

export function getSearchTitle({
    transportType,
    from,
    to,
}: {
    transportType: FilterTransportType;
    from: IPoint;
    to: IPoint;
}): string {
    const titleParams = {
        from: from.title,
        to: to.title,
    };

    switch (transportType) {
        case FilterTransportType.suburban:
            return keyset('title-suburban', titleParams);
        case FilterTransportType.train:
            return keyset('title-train', titleParams);
        case FilterTransportType.plane:
            return keyset('title-plane', titleParams);
        case FilterTransportType.bus:
            return keyset('title-bus', titleParams);
        case FilterTransportType.water:
            return keyset('title-water', titleParams);

        default:
            return keyset('title-all', titleParams);
    }
}
