import {FilterTransportType} from '../transportType';
import IStateFlags from '../../interfaces/state/flags/IStateFlags';

const SEGMENTS_MINIMUM_FOR_TRANSFER = 3;

export const getSegmentsMinimumForTransfer = ({
    flags,
    transportType,
}: {
    flags?: IStateFlags;
    transportType: FilterTransportType;
}): number => {
    const minSegmentsWithoutTransferString =
        flags?.RASP_min_segments_without_transfer;

    if (
        !minSegmentsWithoutTransferString ||
        transportType !== FilterTransportType.train
    ) {
        return SEGMENTS_MINIMUM_FOR_TRANSFER;
    }

    const minSegmentsWithoutTransfer = parseInt(
        minSegmentsWithoutTransferString,
        10,
    );

    if (!isNaN(minSegmentsWithoutTransfer)) {
        return minSegmentsWithoutTransfer;
    }

    return SEGMENTS_MINIMUM_FOR_TRANSFER;
};
