import {FilterTransportType} from '../transportType';
import IStateSearch from '../../interfaces/state/search/IStateSearch';

import isTransfer from '../segments/isTransfer';
import IStateFlags from '../../interfaces/state/flags/IStateFlags';
import shouldRequestSuburbanTransfer from './shouldRequestSuburbanTransfer';
import {getSegmentsMinimumForTransfer} from './getSegmentsMinimumForTransfer';

export default function getTransportTypeForRequestTransfer(
    searchState: IStateSearch,
    flags?: IStateFlags,
): FilterTransportType | undefined {
    const {context, segments} = searchState;
    const {transportType, when} = context;

    const segmentsMinimumForTransfer = getSegmentsMinimumForTransfer({
        flags,
        transportType,
    });

    if (
        when.date &&
        segments.filter(segment => !isTransfer(segment)).length <
            segmentsMinimumForTransfer
    ) {
        return transportType;
    }

    return shouldRequestSuburbanTransfer(context)
        ? FilterTransportType.suburban
        : undefined;
}
