import {ALLOW_INSIDE_COUNTY_BOOKING_COUNTRIES} from '../countries';

import ISearchContext from '../../interfaces/state/search/ISearchContext';

export default function isOpenedForSaleTrainDirection(
    context: ISearchContext,
): boolean {
    const from = context.from.country ? context.from.country.code : '';
    const to = context.to.country ? context.to.country.code : '';

    return from !== to || ALLOW_INSIDE_COUNTY_BOOKING_COUNTRIES.includes(from);
}
