import {momentTimezone as moment} from '../../../reexports';

import {getToday, isOutOfRange, getOrderRange} from '../date/utils';
import {TRAIN_TYPE} from '../transportType';

export const SALES_LIMIT = {
    [TRAIN_TYPE]: 119, // с 1 апреля 2019 открыта продажа билетов за 120 суток
};

/**
 * Метод определяет попадает ли поисковый запрос за рамки диапазона продаж
 *
 * @param {Object} context - поисковый контекст
 *
 * @return {boolean}
 */
export function isOutOfSellRange(context) {
    const {time, transportTypes} = context;

    if (transportTypes.length === 1) {
        const type = transportTypes[0];
        const today = getToday(time);
        const date = moment.tz(context.when.date, time.timezone);

        return isOutOfRange(
            date,
            getOrderRange(today, type, SALES_LIMIT[type]),
        );
    }

    return false;
}
