import filterSegmentsWithIncorrectPrice from './filterSegmentsWithIncorrectPrice';

/**
 * На основе ответов от ручек возвращает, запрашивать ли цены для самолетов дальше
 * @param {Array} answers
 * @return {boolean}
 */
const getPlanesQuerying = answers => {
    const {planeTariffs, planeQIds} = Object.assign({}, ...answers);
    const {qids} = planeQIds || {};

    return (
        (qids && Boolean(qids.length)) ||
        (planeTariffs && planeTariffs.querying)
    );
};

/**
 * Метод объединяет данные из ответов ручек динамических цен (демон, уфс, автобусы) в одну структуру
 * @param {Object[]} answers - массив данных из ответов динамических цен
 * @param {Object} currencies - данные валют
 * @return {{segments: Object[], querying: Object}}
 */
export default function joinDynamicPriceAnswers(answers, currencies) {
    const {busTariffs, planeTariffs, trainTariffs} = Object.assign(
        {},
        ...answers,
    );

    return {
        segments: [
            ...((busTariffs &&
                filterSegmentsWithIncorrectPrice(
                    busTariffs.segments,
                    currencies,
                )) ||
                []),
            ...((planeTariffs && planeTariffs.segments) || []),
            ...((trainTariffs && trainTariffs.segments) || []),
        ],
        querying: {
            ...(busTariffs
                ? {
                      bus: Boolean(
                          busTariffs.busRequestTimeoutError ||
                              busTariffs.querying,
                      ),
                  }
                : null),
            ...{plane: getPlanesQuerying(answers)},
            ...(trainTariffs ? {train: trainTariffs.querying} : null),
        },
    };
}
