/**
 * Возвращает объединённые статические ответы
 * @param {Object[]} answers
 * @return {Array[]}
 */
export default function joinStaticPriceAnswers(answers) {
    const {staticTariffs, allDaysTariffs, suburbanTariffs} = Object.assign(
        {},
        ...answers,
    );

    return [
        ...((staticTariffs && staticTariffs.tariffs) || []),
        ...((allDaysTariffs && allDaysTariffs.tariffs) || []),
        ...((suburbanTariffs && suburbanTariffs.tariffs) || []),
    ];
}
