import {FilterTransportType} from '../transportType';
import ITransferFromApi from '../../interfaces/transfer/ITransferFromApi';
import TransferQueryStatus from '../../interfaces/transfer/TransferQueryStatus';
import IApiTransferResponce from '../../interfaces/api/IApiTransferResponse';

import mergeTransfers from './mergeTransfers';

export type IJoinedTransfersAnswersStatus = {
    [key in FilterTransportType]?: TransferQueryStatus;
};

export interface IJoinedTransfersAnswers {
    transfers: ITransferFromApi[];
    status: IJoinedTransfersAnswersStatus;
    transportTypes: FilterTransportType[];
}

export default function joinTransferAnswers(
    answers: any[],
): IJoinedTransfersAnswers {
    const transferAnswers = answers.filter(
        answer =>
            answer && answer.transfers && answer.status && answer.transportType,
    ) as IApiTransferResponce[];

    const allTransfers = ([] as ITransferFromApi[]).concat(
        ...transferAnswers.map(answer => answer.transfers),
    );
    const mapTransfers: Map<string, ITransferFromApi> = new Map();

    allTransfers.forEach(transfer => {
        const {id} = transfer;
        const transferInMap = mapTransfers.get(id);

        if (!transferInMap) {
            return mapTransfers.set(id, transfer);
        }

        const mergedTransfer = mergeTransfers(transferInMap, transfer);

        mapTransfers.set(id, mergedTransfer);
    });

    return {
        transfers: [...mapTransfers.values()],
        status: transferAnswers.reduce((statuses, {transportType, status}) => {
            statuses[transportType] = status;

            return statuses;
        }, {}),
        transportTypes: transferAnswers.map(({transportType}) => transportType),
    };
}
