import ITransferFromApi from '../../interfaces/transfer/ITransferFromApi';
import ITransferSegmentFromApi from '../../interfaces/transfer/ITransferSegmentFromApi';

export class ErrorMergeTransfer extends Error {
    constructor(...args) {
        super(...args);
    }
}

function hasTariffs(
    segment: ITransferFromApi | ITransferSegmentFromApi,
): boolean {
    return Boolean(segment.tariffs);
}

export default function mergeTransfers(
    a: ITransferFromApi,
    b: ITransferFromApi,
): ITransferFromApi {
    if (a.id !== b.id) {
        throw new ErrorMergeTransfer('Разные id у пересадок');
    }

    // Проверка идентичности количества и id сегментов
    if (
        a.segments.length !== b.segments.length ||
        !a.segments.every(
            ({id}) => id && b.segments.find(bSegment => bSegment.id === id),
        )
    ) {
        throw new ErrorMergeTransfer('Разные наборы сегментов');
    }

    const mergedSegments = a.segments.map(aSegment => {
        if (hasTariffs(aSegment)) {
            return aSegment;
        }

        const bSegment = b.segments.find(({id}) => id === aSegment.id);

        if (bSegment && hasTariffs(bSegment)) {
            return bSegment;
        }

        return aSegment;
    });

    const identicalSegments = mergedSegments.every(mergedSegment =>
        a.segments.includes(mergedSegment),
    );
    const aHasTariffs = hasTariffs(a);
    const bHasTariffs = hasTariffs(b);
    const identicalTariffs = aHasTariffs === bHasTariffs;

    if (identicalSegments && identicalTariffs) {
        return a;
    }

    const mergedTariffs = aHasTariffs ? a.tariffs : b.tariffs;

    return {
        ...a,
        tariffs: mergedTariffs,
        segments: mergedSegments,
    };
}
