import IApi from '../../interfaces/api/IApi';
import {FilterTransportType} from '../transportType';
import Lang from '../../interfaces/Lang';
import Tld from '../../interfaces/Tld';
import IStateFlags from '../../interfaces/state/flags/IStateFlags';
import TransferQueryStatus from '../../interfaces/transfer/TransferQueryStatus';
import IApiTransferResponse from '../../interfaces/api/IApiTransferResponse';
import IExpressRequest from '../../interfaces/IExpressRequest';
import Point from '../../interfaces/Point';

interface IRequestTransfer {
    transportType: FilterTransportType;
    pointFrom: Point;
    pointTo: Point;
    when: string;
    language: Lang;
    tld: Tld;
    poll: boolean;
    api: IApi;
    flags: IStateFlags;

    isBot?: boolean;
    req?: IExpressRequest;
}

export default async ({
    transportType,
    pointFrom,
    pointTo,
    when,
    language,
    tld,
    poll,
    api,
    flags,

    isBot,
    req,
}: IRequestTransfer): Promise<IApiTransferResponse> => {
    if (!when) {
        return {
            transfers: [],
            status: TransferQueryStatus.done,
            transportType,
        };
    }

    const apiParams = {
        transportType,
        pointFrom,
        pointTo,
        when,
        language,
    };

    const transfers = await api.execTransfersWithPrices(
        {...apiParams, tld, poll, isBot, flags},
        req,
    );

    return {
        ...transfers,
        transportType,
    };
};
