import {SUBURBAN_TYPE} from '../transportType';

/**
 * Метод определяет необходимость запроса цен на выдаче
 * @param {Object} context - поисковый контекст
 * @param {Object} context.searchForPastDate - признак поиска на прошедшую дату
 * @param {Object} context.transportType - тип транспорта
 * @return {boolean}
 */
export default function shouldRequestPrices({
    searchForPastDate,
    transportType,
}) {
    return !searchForPastDate && transportType !== SUBURBAN_TYPE;
}
