import {FilterTransportType} from '../transportType';
import ISearchContext from '../../interfaces/state/search/ISearchContext';

export default function shouldRequestSuburbanTransfer(
    searchContext: ISearchContext,
): boolean {
    const {
        when: {date},
        sameSuburbanZone,
        transportType,
    } = searchContext;

    return Boolean(
        date &&
            sameSuburbanZone &&
            transportType === FilterTransportType.suburban,
    );
}
