import {ALL_TYPE, TRAIN_TYPE, SUBURBAN_TYPE} from '../transportType';

import isAllDaysSearch from './isAllDaysSearch';
import {isOutOfSellRange} from './isOutOfSellRange';
import isOpenedForSaleTrainDirection from './isOpenedForSaleTrainDirection';

const SUPPORTED_TRANSPORT_TYPES = [ALL_TYPE, TRAIN_TYPE, SUBURBAN_TYPE];

/**
 * Проверка - нужно ли запрашивать цены на поезда из ручки trainTariffs
 * @param {Object} context - объект контекста из store
 * @param {Object} flags - флаги управления эксперементальными фичами
 * @return {boolean}
 */
export default function shouldRequestTrainTariffs(context, flags) {
    const outOfSellRange =
        flags && flags.__ufsTesting && isOutOfSellRange(context);
    const {transportType} = context;

    if (
        isAllDaysSearch(context) ||
        outOfSellRange ||
        !SUPPORTED_TRANSPORT_TYPES.includes(transportType)
    ) {
        return false;
    }

    return isOpenedForSaleTrainDirection(context, flags);
}
