import {ALL_TYPE, BUS_TYPE} from '../transportType';
import {TLD_UA} from '../tlds';
import isAllDaysSearch from './isAllDaysSearch';

/**
 * Возвращает признак возможности запроса цен у Я.Автобусов
 * @param {Object} context - поисковый контекст
 * @param {string} nationalVersion - национальная версия
 * @return {boolean}
 */
export default function shouldRequestYBus(context, nationalVersion) {
    if (isAllDaysSearch(context)) {
        return false;
    }

    const {transportType} = context;

    return (
        nationalVersion !== TLD_UA &&
        (transportType === ALL_TYPE || transportType === BUS_TYPE)
    );
}
