const ALL_PAGES_TYPE = 'all';
const SUBURBAN_PAGE_TYPE = 'suburban';
const PAGE_TYPES = [ALL_PAGES_TYPE, SUBURBAN_PAGE_TYPE];

export const DEFAULT_SEARCH_CALENDAR_VISIBILITY = {
    [ALL_PAGES_TYPE]: true,
    [SUBURBAN_PAGE_TYPE]: false,
};

const cookieName = pageType => `search-calendar-${pageType}`;

export function loadSearchCalendarVisibility(cookies) {
    return PAGE_TYPES.reduce((result, pageType) => {
        const value = cookies.get(cookieName(pageType));

        if (value) {
            return {
                ...result,
                [pageType]: value === 'true', // в куках только текст
            };
        }

        return result;
    }, {});
}

export function saveSearchCalendarVisibility(cookies, visibility) {
    Object.keys(visibility).forEach(pageType => {
        cookies.set(cookieName(pageType), visibility[pageType]);
    });
}

export function getSearchCalendarPageType({isSuburbanSearchResult}) {
    return isSuburbanSearchResult ? SUBURBAN_PAGE_TYPE : ALL_PAGES_TYPE;
}

export function isSearchCalendarVisible(props) {
    const pageType = getSearchCalendarPageType(props);

    return props.visibility[pageType];
}
