'use strict';

import {createItem, findItem, compareItems} from './utils';
import validate from './validate';

export function initializeSearchHistoryItems(items) {
    return (items || [])
        .filter(item => validate(item.value))
        .sort(compareItems);
}

export function addItemToSearchHistory(items, value) {
    if (!validate(value)) {
        return items;
    }

    const {item, index} = findItem(items, value);

    const newItems = [...items];

    if (item) {
        const newItem = {
            ...item,
            priority: item.priority + 1,
        };

        newItems[index] = newItem;
    } else {
        const newItem = createItem(value);

        newItems.unshift(newItem);
    }

    return newItems;
}

export function favoriteSearchHistoryItem(items, value, favorite) {
    const {item, index} = findItem(items, value);

    if (!item) {
        return items;
    }

    const newItems = [...items];
    const newItem = {
        ...item,
        favorite,
    };

    newItems[index] = newItem;

    return newItems;
}
