'use strict';

export function compareItems(itemA, itemB) {
    if (itemA.favorite === itemB.favorite) {
        return itemB.priority - itemA.priority;
    }

    return itemA.favorite ? -1 : 1;
}

export function findItem(items, value) {
    const index = items.findIndex(
        item =>
            item.value.from.key === value.from.key &&
            item.value.to.key === value.to.key,
    );

    return {
        item: index < 0 ? null : items[index],
        index,
    };
}

export function createItem(value) {
    return {
        value,
        priority: 0,
        favorite: false,
    };
}

export function validateField(fieldValue) {
    return Boolean(fieldValue && fieldValue.key);
}
