import patchTariffs from './tariffs/patchTariffs';

function patchSegment(segment, tariffs, meta) {
    const matchingTariff = tariffs.find(
        tariff =>
            segment.tariffsKeys && segment.tariffsKeys.includes(tariff.key),
    );

    if (matchingTariff) {
        return {
            ...segment,
            tariffs: patchTariffs(segment, matchingTariff, meta),
        };
    }

    return segment;
}

export default function addTariffsToSegments(segments, tariffs, meta) {
    return segments.map(segment => {
        if (segment.isMetaSegment) {
            segment.subSegments = segment.subSegments.map(subsegment =>
                patchSegment(subsegment, tariffs, meta),
            );
        }

        return patchSegment(segment, tariffs, meta);
    });
}
