import {TransportType} from '../transportType';

export default function addTrainPartnersToSegment({segment, trainPartners}) {
    const {transport} = segment;

    if (!transport) {
        return segment;
    }

    const {code: transportType} = transport;

    // Для электричек ЦППК (которые одновременно являются поездами) нужно добавлять поле trainPartners
    // для формирования ссылки на покупку на travel
    if (
        transportType !== TransportType.train &&
        transportType !== TransportType.suburban &&
        !segment.trainPurchaseNumbers
    ) {
        return segment;
    }

    segment.trainPartners = trainPartners;

    if (segment.subSegments) {
        segment.subSegments.forEach(subsegment => {
            subsegment.trainPartners = trainPartners;
        });
    }

    return segment;
}
