import {getBaseTariffClassKeys} from './getBaseTariffClassKeys';

/**
 * Функция проверяет у всех ли сегментов есть цена
 * @param {Object[]} segments
 * @param {string} [transportType] - тип транспорта. Если задан, то проверяет только по выбранному типу.
 * @return {boolean}
 */
export default function areAllSegmentsWithPrice(segments = [], transportType) {
    const segmentsByType = transportType
        ? segments.filter(({transport}) => transport.code === transportType)
        : segments;

    if (!segmentsByType.length) {
        return false;
    }

    return segmentsByType.every(
        segment => getBaseTariffClassKeys(segment).length,
    );
}
