import {MAX_EACH_BADGE_COUNT} from '../constants';

import filterTariffs from './filterTariffs';

/**
 * Проверяет, много ли сегментов оказались хотя бы по одной из цен "самыми дешевыми"
 * @param {Object} segments -- все сегменты текущей выдачи
 * @param {number} cheapestValue -- значение минимальной цены среди всех сегментов
 * @param {number} percentToOffBadges -- порог отключения бейджиков
 * @return {boolean}
 */
export default function checkIsManyCheapest(
    segments,
    cheapestValue,
    percentToOffBadges,
) {
    const segmentsWithPrice = filterTariffs(segments);

    const cheapestSegments = segmentsWithPrice.filter(segment =>
        Object.values(segment.tariffs.classes).some(
            tariffsClass =>
                Math.floor(tariffsClass.nationalPrice.value) === cheapestValue,
        ),
    );

    const {length: cheapestSegmentsCount} = cheapestSegments;

    return (
        cheapestSegmentsCount > MAX_EACH_BADGE_COUNT ||
        cheapestSegmentsCount / segmentsWithPrice.length > percentToOffBadges
    );
}
