import filterTariffs from './filterTariffs';

/**
 * Поиск значения самого дешевого тарифа
 * @param {Object} segments -- все сегменты текущей выдачи
 * @return {number} -- Integer
 */
export default function findCheapestValue(segments) {
    let cheapest = Infinity;

    const segmentsWithPrice = filterTariffs(segments);

    segmentsWithPrice.forEach(segment => {
        Object.values(segment.tariffs.classes).forEach(tariffsClass => {
            if (tariffsClass.nationalPrice.value < cheapest) {
                cheapest = tariffsClass.nationalPrice.value;
            }
        });
    });

    return Math.floor(cheapest);
}
