import ISegment from 'common/interfaces/segment/ISegment';
import havePrices from '../../havePrices';
import {IBadgesData} from '../getBadgesData';

/** Отвечает, подходит ли какая-то из цен в сегменте под определение "самый дешевый" */
export default function isCheapest(
    segment: ISegment,
    {cheapestValue, isManyCheapest}: IBadgesData,
): boolean {
    if (cheapestValue !== 0 && !isManyCheapest && havePrices(segment)) {
        return Object.values(segment.tariffs?.classes || {}).some(
            tariffsClass =>
                cheapestValue === Math.floor(tariffsClass.nationalPrice.value),
        );
    }

    return false;
}
