import {MAX_EACH_BADGE_COUNT} from '../constants';

/**
 * Функция проверят, не привышает ли количетсво "самых быстрых" сегментов критического значения (percentToOffBadges)
 * @param {Object[]} segments - сегменты
 * @param {number} fastestSegmentValue - значение времени в пути самого быстрого сегмента
 * @param {number} percentToOffBadges - максимальная доля "самых быстрых" сегментов
 * @return {boolean}
 */
export default function checkIsManyFastest(
    segments,
    fastestSegmentValue,
    percentToOffBadges,
) {
    const {length: fastestSegmentsCount} = segments.filter(
        ({duration}) => duration === fastestSegmentValue,
    );

    return (
        fastestSegmentsCount > MAX_EACH_BADGE_COUNT ||
        fastestSegmentsCount / segments.length > percentToOffBadges
    );
}
