import ISegment from 'common/interfaces/segment/ISegment';
import ISubSegment from 'common/interfaces/segment/ISubSegment';
import isSegment from '../../isSegment';

/** Функция возвращает самое минимальное время в пути среди сегментов */
export default function findFastestSegmentValue(
    segments: (ISegment | ISubSegment)[],
): number {
    return segments.reduce((fastestDuration, segment) => {
        const {duration} = segment;

        const subSegmentsFastestDuration: number =
            (isSegment(segment) &&
                segment.subSegments &&
                findFastestSegmentValue(segment.subSegments)) ||
            Infinity;

        return Math.min(fastestDuration, duration, subSegmentsFastestDuration);
    }, Infinity);
}
