import ISegment from 'common/interfaces/segment/ISegment';
import ISegmentBadges from 'common/interfaces/segment/ISegmentBadges';

import isCheapest from './cheapest/isCheapest';
import isFastestSegment from './fastest/isFastestSegment';
import {IBadgesData} from './getBadgesData';

/** Получение всех подходящих бейджиков для сегмента */
export default function getAppropriateBadges(
    segment: ISegment,
    {
        cheapestValue,
        isManyCheapest,
        fastestSegmentValue,
        isManyFastest,
    }: IBadgesData,
): ISegmentBadges {
    const badges: ISegmentBadges = {};

    if (isCheapest(segment, {cheapestValue, isManyCheapest})) {
        badges.cheapest = true;
    }

    if (!isManyFastest && isFastestSegment(segment, fastestSegmentValue)) {
        badges.fastest = true;
    }

    return badges;
}
