import ISegment from '../../interfaces/segment/ISegment';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';
import ISubSegment from '../../interfaces/segment/ISubSegment';
import ISearchFiltering from '../../interfaces/state/search/ISearchFiltering';

import {
    getBaseTariffClassKeys,
    filterTariffClassKeys,
} from './getBaseTariffClassKeys';
import {getSegmentTimes} from './cachedSegmentTime';
import {makeCacheable} from '../cache';
import isTransfer from './isTransfer';
import isSegment from './isSegment';

type Segment = ISegment | ITransfer | ITransferSegment | ISubSegment;

const getCachedSegment = makeCacheable(
    <T extends Segment>(
        segment: T,
        tariffClassKeysString: string,
        filtering?: ISearchFiltering,
    ): T => ({
        ...segment,
        tariffClassKeys: tariffClassKeysString
            ? tariffClassKeysString.split(',')
            : [],
        ...getSegmentTimes(segment),
        ...(isTransfer(segment)
            ? {
                  segments: segment.segments.map(transferSegment =>
                      buildSegmentRenderingData(transferSegment, filtering),
                  ),
              }
            : {}),
        ...(isSegment(segment) && segment.subSegments
            ? {
                  subSegments: segment.subSegments.map(subSegment =>
                      buildSegmentRenderingData(subSegment, filtering),
                  ),
              }
            : {}),
    }),
);

export default function buildSegmentRenderingData<T extends Segment>(
    segment: T,
    filtering?: ISearchFiltering,
): T {
    const tariffClassKeysString = filterTariffClassKeys({
        tariffClassKeys: getBaseTariffClassKeys(segment),
        segment,
        filtering,
    }).join(',');

    return getCachedSegment(segment, tariffClassKeysString, filtering);
}
