import makeExternalUrl from '../../url/makeExternalUrl';

/**
 * WARN! Функция модифицирует входные данные.
 * Патчит тарифы спецфлагом для автобусов
 * @param {Object} updateSegment - данные сегмента от автобусов
 * @return {Object|undefined} - данные о тарифах
 */
export default function patchBusUrl(updateSegment) {
    const {tariffs} = updateSegment;
    const {classes} = tariffs || {};

    if (!classes) {
        return;
    }

    Object.keys(classes).forEach(key => {
        const {parsedUrl} = classes[key];

        if (parsedUrl) {
            const {pathname, query = {}} = parsedUrl;

            classes[key].orderUrl = makeExternalUrl(pathname, {
                ...query,
                hide_station: 1,
            });
        }
    });

    return tariffs;
}
