import patchBusUrl from './patchBusUrl';
import {isCity} from '../../point/pointType';
import patchTariffs from '../tariffs/patchTariffs';

/**
 * Метод добавляет информацию о тарифах (Я.Автобусы) к базовому сегменту
 * @param {Object} baseSegment - базовый сегмент из ответа ручки search
 * @param {Object} updateSegment - сегмент с ценой из ответа ручки busTariffs
 * @param {Object} meta - кусок из store
 * @return {Object} - сегмент с ценой и дополнительными полями
 */
export default function updateYBusSegment(baseSegment, updateSegment, meta) {
    const {context} = meta;
    const {number, source, yBusId, stationTo, useCityInsteadStationTo} =
        updateSegment;

    const stationsAreDifferent =
        baseSegment.stationTo &&
        stationTo &&
        baseSegment.stationTo.id !== stationTo.id;
    const tariffs = stationsAreDifferent
        ? patchBusUrl(updateSegment)
        : updateSegment.tariffs;

    return {
        ...baseSegment,
        source,
        yBusId,
        stationsAreDifferent,
        number: number || baseSegment.number,
        tariffs: patchTariffs(updateSegment, tariffs, meta),
        useCityInsteadStationTo:
            useCityInsteadStationTo ||
            (stationsAreDifferent && isCity(context.to)),
    };
}
