import AllSegmentType from '../../interfaces/segment/AllSegmentType';

import isTransfer from './isTransfer';
import havePriceAndSeats from './tariffs/havePriceAndSeats';

// Возвращает признак того, что данная пересадка продается как интерлайн (в одну транзакцию)
export default function checkIsInterline(segment: AllSegmentType): boolean {
    return isTransfer(segment) && havePriceAndSeats(segment);
}
