import {TRAIN_TYPE} from '../transportType';

/**
 * Если в пределах одних суток имеется 2 поезда с одинаковым номером, то необходимо
 * закрывать продажу на второй (т.к. из-за бага/фичи системы "Экспресс"
 * на него невозможно приобрести билет).
 *
 * @param {Object[]} segments
 *
 * @return {Object[]}
 */
export default function clearDuplicateTrainTariffs(segments) {
    const duplicates = {};

    // ищем дубликаты среди поездов
    for (let i = 0; i < segments.length; i++) {
        const segment = segments[i];
        const {transport, number} = segment;

        if (transport.code === TRAIN_TYPE) {
            if (!duplicates[number]) {
                duplicates[number] = [];
            }

            duplicates[number].push(segment);
        }
    }

    Object.keys(duplicates).forEach(key => {
        const variants = duplicates[key];
        const times = [];

        // ищем дубликаты с уникальным временем отправления
        // если время отправления совпадает - кейс соответствует случаю, когда мы
        // показываем поезда между 0 и 4 часами
        for (let i = 0; i < variants.length; i++) {
            const {departure} = variants[i];
            const departureTime = departure.split('T')[1];

            if (!times.includes(departureTime)) {
                times.push(departureTime);
            }
        }

        // если время отправления не совпадает, то убираем информацию о тарифах
        if (times.length > 1) {
            variants
                .sort((a, b) => a.departure.localeCompare(b.departure))
                .slice(1) // для первого поезда оставляем покупку
                .forEach(segment => {
                    segment.tariffs = null;
                });
        }
    });

    return segments;
}
