import SegmentEventType from '../../../interfaces/segment/SegmentEventType';
import EndpointData from '../../../interfaces/lib/segments/EndpointData';
import ITransferSegment from '../../../interfaces/transfer/ITransferSegment';
import ISegment from '../../../interfaces/segment/ISegment';
import ITransfer from '../../../interfaces/transfer/ITransfer';

import isTransferSegment from '../isTransferSegment';
import isTransfer from '../isTransfer';

import delayKeyset from '../../../i18n/delay-status';
import segmentKeyset from '../../../i18n/segment';

const goneData = {
    isDelay: false,
    isGone: true,
    text: segmentKeyset('gone-title'),
};

// Если есть данные по опозданиям, функция вернёт строчку с соответствующим текстом
export default function getEndpointsData(
    segment: ISegment | ITransfer | ITransferSegment,
): EndpointData {
    const {isGone} = segment;

    // обработка пересадки или сегмента пересадки
    if (isTransfer(segment) || isTransferSegment(segment)) {
        if (isGone) {
            return goneData;
        }

        return null;
    }

    // обработка сегмента
    const {departureEvent} = segment;

    if (!departureEvent) {
        if (isGone) {
            return goneData;
        }

        return null;
    }

    // В первом приближении используем только данные из события отправления
    const {minutesFrom, minutesTo} = departureEvent;
    const isRange = minutesFrom !== minutesTo;
    const props = {
        ...departureEvent,
        isRange,
    };

    switch (departureEvent.type) {
        case SegmentEventType.possibleDelay:
            if (isGone) {
                return goneData;
            }

            return {
                isDelay: true,
                eventType: SegmentEventType.possibleDelay,
                text: delayKeyset(SegmentEventType.possibleDelay, props),
            };
        case SegmentEventType.fact: {
            const isDelay = minutesTo > 1;

            return {
                isDelay,
                eventType: SegmentEventType.fact,
                text: delayKeyset(isDelay ? 'delay' : 'ok', props),
            };
        }
    }

    return null;
}
