import ISegmentFromApi from 'common/interfaces/segment/ISegmentFromApi';

import isUpdateCheaper from './isUpdateCheaper';

// Проверяет, что для сегмента можно построить ссылку на покупку
const haveOrderLink = (segment: ISegmentFromApi): boolean => {
    const {tariffs} = segment;

    if (!tariffs) {
        return false;
    }

    const {classes} = tariffs;
    const classOrderUrl = Object.entries(classes).find(([, tariff]) => {
        const {price, seats, orderUrl, trainOrderUrl} = tariff;

        if (!price.value) {
            return false;
        }

        if (seats !== undefined && seats < 1) {
            return false;
        }

        return orderUrl || trainOrderUrl;
    });

    return Boolean(classOrderUrl);
};

// Метод выбирает сегмент на основе информации о тарифах
export default function getBestSegment(
    baseSegment: ISegmentFromApi,
    updateSegments: ISegmentFromApi[],
): ISegmentFromApi {
    return updateSegments.reduce((bestSegment, segment) => {
        // Если тарифа нет - смело возвращаем сегмент из тарифов
        if (!bestSegment.tariffs && segment.tariffs) {
            return segment;
        }

        // Если у текущего тарифа нет ссылки для покупки, а у сегмента
        // из тарифов ссылка есть - возвращаем сегмент с ссылкой
        if (!haveOrderLink(bestSegment) && haveOrderLink(segment)) {
            return segment;
        }

        // Если текущий сегмент содержит более выгодный тариф - возвращаем его
        if (isUpdateCheaper(bestSegment, segment)) {
            return segment;
        }

        return bestSegment;
    }, baseSegment);
}
