import {SORTING_TYPES} from '../sort/utils';
import isAllDaysSearch from '../search/isAllDaysSearch';
import {getDepartureTime, getArrivalTime} from './cachedSegmentTime';

/*
 * Метод определяет необходимость отображения даты отправления/прибытия и разделителя суток
 * @param {numbers[]} vector - массив индексов сегментов
 * @param {boolean[]} filteredSegmentIndices - массив фильтрации сегментов
 * @param {Object[]} segments - массив сгментов
 * @param {Object} context - поисковый контекст
 * @param {Object} sort - объект сортировки
 * @returns {Object}
 */
export default function getDatesVisibility({
    vector,
    filteredSegmentIndices,
    segments,
    context,
    sort = {},
}) {
    if (!isAllDaysSearch(context)) {
        const datesSeparatorIsAvailable = sort.by === SORTING_TYPES.DEPARTURE;
        const timezoneFrom = context.from.timezone;
        const timezoneTo = context.to.timezone;

        return vector
            .filter(index => filteredSegmentIndices[index])
            .reduce(
                ({prevSegment, result}, index) => {
                    if (segments[index]) {
                        const currentSegment = {
                            departureDate: getDepartureTime(
                                segments[index],
                                timezoneFrom,
                            ).date(),
                            arrivalDate: getArrivalTime(
                                segments[index],
                                timezoneTo,
                            ).date(),
                        };
                        const differentDepartureDates =
                            prevSegment.departureDate !==
                            currentSegment.departureDate;
                        const showDatesSeparator =
                            datesSeparatorIsAvailable &&
                            Boolean(prevSegment.departureDate) &&
                            differentDepartureDates;

                        result[index] = {
                            showDatesSeparator,
                            showDepartureDate:
                                !showDatesSeparator && differentDepartureDates,
                            showArrivalDate:
                                prevSegment.arrivalDate !==
                                currentSegment.arrivalDate,
                        };

                        return {
                            prevSegment: currentSegment,
                            result,
                        };
                    }

                    return {
                        prevSegment,
                        result,
                    };
                },
                {prevSegment: {}, result: {}},
            ).result;
    }

    return {};
}
