/**
 * Возвращает прямые сегменты. Плюс фильтрация по типу транспарта, если задан.
 * @param {Object[]} segments
 * @param {string} [transportType]
 * @return {Object[]}
 */
export default function getDirectSegments(segments, transportType) {
    return segments.filter(
        ({transport, segments: transferSegments}) =>
            !transferSegments &&
            (!transportType || transport.code === transportType),
    );
}
